package com.finconsgroup.itserr.marketplace.metadata.integration.autoconfigure;

import com.finconsgroup.itserr.marketplace.core.common.io.YamlPropertySourceFactory;
import com.finconsgroup.itserr.marketplace.core.web.autoconfigure.ApiClientAutoConfiguration;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.MetadataLibsMetadataDmClient;
import com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.exception.MetadataLibsIntegrationErrorDecoder;
import com.finconsgroup.itserr.marketplace.metadata.integration.mapper.FieldMapper;
import com.finconsgroup.itserr.marketplace.metadata.integration.service.MetadataValidationService;
import com.finconsgroup.itserr.marketplace.metadata.integration.service.impl.DefaultMetadataValidationService;
import com.finconsgroup.itserr.marketplace.metadata.lib.autoconfigure.MetadataValidationAutoConfiguration;
import com.finconsgroup.itserr.marketplace.metadata.lib.validation.field.FieldValidator;
import org.mapstruct.factory.Mappers;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

import java.util.List;

/**
 * This class autoconfigure the metadata validation integration library, by providing a {@link MetadataValidationService} bean to validate metadata values
 * according to a metadata defined in metadata-dm microservice.
 */
@Import(MetadataValidationAutoConfiguration.class)
@AutoConfiguration(
        before = ApiClientAutoConfiguration.class,
        after = MetadataValidationAutoConfiguration.class)
@PropertySource(name = "metadata-integration", value = { "classpath:/metadata-integration-library.yaml" }, factory = YamlPropertySourceFactory.class)
public class MetadataIntegrationAutoConfiguration {

    /**
     * Provides a {@link MetadataValidationService} instance to validate metadata integrating with validation-dm microservice.
     *
     * @param fieldValidators Metadata validation library field validators.
     * @param client metadata-dm microservice client.
     * @param fieldMapper Field mapper.
     * @return MetadataValidationService instance.
     */
    @Bean
    public static MetadataValidationService metadataValidationService(
            final List<FieldValidator> fieldValidators,
            final MetadataLibsMetadataDmClient client,
            final FieldMapper fieldMapper) {

        return new DefaultMetadataValidationService(
                fieldValidators,
                client,
                fieldMapper);

    }

    /**
     * Creates and registers a bean of type {@link MetadataLibsIntegrationErrorDecoder}.<br> This decoder handles custom error handling for Feign clients,
     * converting HTTP response statuses into specific exceptions.
     *
     * @return an instance of {@link MetadataLibsIntegrationErrorDecoder} to serve as a custom Feign {@link feign.codec.ErrorDecoder}.
     */
    @Bean
    public static MetadataLibsIntegrationErrorDecoder metadataLibsIntegrationErrorDecoder() {
        return new MetadataLibsIntegrationErrorDecoder();
    }

    /**
     * Provides a bean of type {@link FieldMapper} to map fields between DTOs and domain model.
     *
     * @return An instance of {@link FieldMapper} used for field mapping operations. Never null.
     */
    @Bean
    public static FieldMapper fieldMapper() {
        return Mappers.getMapper(FieldMapper.class);
    }

}
