package com.finconsgroup.itserr.marketplace.metadata.integration.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.metadata.lib.ConstraintViolation;
import lombok.Getter;
import org.springframework.lang.NonNull;

import java.util.Collection;
import java.util.List;

/**
 * <p>Represents a business exception caused by metadata fields values violating rules.</p>
 */
@Getter
public class WP2InvalidMetadataException extends WP2BusinessException {

    /** Metadata violations. */
    private final List<ConstraintViolation> violations;

    /**
     * Constructor.
     *
     * @param violations Metadata violations. Cannot be null.
     */
    public WP2InvalidMetadataException(@NonNull final Collection<ConstraintViolation> violations) {
        super("Invalid metadata");
        this.violations = List.copyOf(violations);
    }

}
