package com.finconsgroup.itserr.marketplace.audit.bs.mapper;

import com.finconsgroup.itserr.marketplace.audit.bs.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Optional;

@Mapper(config = MapperConfiguration.class)
public interface AuditLogMapper {

    String NAME_CLOUD_EVENT_SOURCE_TO_STRING = "cloudEventSourceToString";

    @Mapping(target = "eventSource", source = "cloudEvent.source", qualifiedByName = NAME_CLOUD_EVENT_SOURCE_TO_STRING)
    @Mapping(target = "eventType", source = "cloudEvent.type")
    @Mapping(target = "user", source = "messagingEventDto.user")
    @Mapping(target = "resource.id", source = "messagingEventDto.id")
    @Mapping(target = "resource.name", source = "messagingEventDto.name")
    @Mapping(target = "resource.title", source = "messagingEventDto.title")
    @Mapping(target = "resource.status", source = "messagingEventDto.status")
    @Mapping(target = "resource.category", source = "messagingEventDto.category")
    @Mapping(target = "eventMessage", source = "messagingEventDto.message")
    @Mapping(target = "eventActionTime", source = "messagingEventDto.timestamp")
    @Mapping(target = "eventAdditionalData", source = "messagingEventDto.additionalData")
    @Mapping(target = "eventCreationTime", source = "cloudEvent.time")
    InputCreateAuditLogDto messagingEventToInputCreateAuditLogDto(UntypedMessagingEventDto messagingEventDto, CloudEvent cloudEvent);

    OutputAuditLogDto auditLogDmDtoToBsDto(com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto outputAuditLogDmDto);

    @Named(NAME_CLOUD_EVENT_SOURCE_TO_STRING)
    default String cloudEventSourceToString(URI source) {
        return source != null ? source.toString() : null;
    }

    @SuppressWarnings("unused")
    default Instant offsetDateTimeToInstant(OffsetDateTime offsetDateTime) {
        return Optional.ofNullable(offsetDateTime).map(OffsetDateTime::toInstant).orElse(null);
    }

}
