/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.service.AuditLogService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.consumer.handler.CloudEventTypeHandler;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component(value="messagingEventConsumer")
public class MessagingEventConsumer
extends CloudEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingEventConsumer.class);
    private final AuditLogService auditLogService;

    public MessagingEventConsumer(AuditLogService auditLogService) {
        super(new CloudEventTypeHandler[0]);
        this.addHandler("*", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (arg_0, arg_1) -> this.handleEvent(arg_0, arg_1));
        this.auditLogService = auditLogService;
    }

    private void handleEvent(UntypedMessagingEventDto eventPayload, @NonNull CloudEvent cloudEvent) {
        OutputAuditLogDto outputAuditLogDto = this.auditLogService.createFromMessagingEvent(eventPayload, cloudEvent);
        log.info("Created audit log with id: {}", (Object)outputAuditLogDto.getId());
    }
}

