package com.finconsgroup.itserr.marketplace.audit.bs.service.impl;

import com.finconsgroup.itserr.marketplace.audit.bs.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.mapper.AuditLogMapper;
import com.finconsgroup.itserr.marketplace.audit.bs.service.AuditLogService;
import com.finconsgroup.itserr.marketplace.audit.dm.client.AuditDmClient;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/**
 * Default implementation of {@link AuditLogService} to perform operations related to AuditLog resources
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultAuditLogService implements AuditLogService {

    private final AuditDmClient auditDmClient;
    private final AuditLogMapper auditLogMapper;

    @NonNull
    @Override
    public OutputAuditLogDto create(@NonNull InputCreateAuditLogDto inputCreateAuditLogDto) {
        com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto outputAuditLogDmDto =
                auditDmClient.createAuditLog(inputCreateAuditLogDto);
        return auditLogMapper.auditLogDmDtoToBsDto(outputAuditLogDmDto);
    }

    @NonNull
    @Override
    public OutputAuditLogDto createFromMessagingEvent(@NonNull UntypedMessagingEventDto messagingEventDto,
                                                      @NonNull CloudEvent cloudEvent) {
        InputCreateAuditLogDto dto = auditLogMapper.messagingEventToInputCreateAuditLogDto(messagingEventDto, cloudEvent);
        return create(dto);
    }
}
