package com.finconsgroup.itserr.marketplace.audit.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.audit.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.audit.dm.util.DomainConstants.SHORT_TEXT_LENGTH;

/**
 * Input DTO for audit log user.
 */
@Schema(name = "InputAuditLogUserDto", description = "Input DTO for audit log user")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputAuditLogUserDto {

    @Schema(description = "The identifier for the user from User Profile whose action triggered the event.",
            example = "177a2792-b41c-435c-a058-51d3b51ff2ee")
    private UUID id;

    @Schema(description = "The preferred username of the user whose action triggered the event.",
            example = "john.doe1234")
    @Size(max = SHORT_TEXT_LENGTH)
    private String username;

    @Schema(description = "The display name of the user whose action triggered the event.", example = "John Doe")
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String name;

}
