package com.finconsgroup.itserr.marketplace.audit.dm.client;

import com.finconsgroup.itserr.marketplace.audit.dm.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.UUID;

/**
 * Feign client interface for Audit Domain Service.
 */
@SuppressWarnings("unused")
public interface AuditDmClient {
    /**
     * Retrieves a paginated list of all audit logs.
     *
     * @param pageNumber the page number to retrieve (default is 0)
     * @param pageSize   the number of UserProfiles per page (default is 10)
     * @param sort       the field to sort by (default is "id")
     * @param direction  the direction of sorting (default is descending)
     * @return a page of {@link OutputAuditLogDto} and HTTP status 200 (OK)
     */
    @GetMapping(value = "/audit/audit-logs", produces = MediaType.APPLICATION_JSON_VALUE)
    OutputPageDto<OutputAuditLogDto> findAll(
            @RequestParam(name = "pageNumber") int pageNumber,
            @RequestParam(name = "pageSize") int pageSize,
            @RequestParam(name = "sort") String sort,
            @RequestParam(name = "direction") SortDirection direction
    );

    /**
     * Retrieves audit log by id.
     *
     * @param id the id of the audit log to retrieve
     * @return the found {@link OutputAuditLogDto} and HTTP status 200 (OK)
     */
    @GetMapping(value = "/audit/audit-logs/{id}", produces = MediaType.APPLICATION_JSON_VALUE)
    OutputAuditLogDto findById(@PathVariable("id") UUID id);

    /**
     * Creates new audit log.
     *
     * @param inputCreateAuditLogDto the input data transfer object containing audit log details
     */
    @PostMapping(
            value = "/audit/audit-logs",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    OutputAuditLogDto createAuditLog(@RequestBody InputCreateAuditLogDto inputCreateAuditLogDto);
}
