package com.finconsgroup.itserr.marketplace.audit.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Response DTO for audit log resource.
 */
@Schema(name = "OutputAuditLogResourceDto", description = "Response DTO for audit log resource")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputAuditLogResourceDto {

    @Schema(description = "The identifier of the resource on which the event was triggered.",
            example = "f71ce693-e760-47d6-bc5c-90edac51c653")
    private String id;

    @Schema(description = "The name of the resource on which the event was triggered.", example = "Talmud")
    private String name;

    @Schema(description = "The title of the resource on which the event was triggered.", example = "Annual Conference")
    private String title;

    @Schema(description = "The category of the resource on which the event was triggered.", example = "project")
    private String category;

    @Schema(description = "The status of the resource on which the event was triggered.", example = "approved")
    private String status;

}
