/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionApplicationEvent;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.component.MessagingDiscussionApplicationEventListener;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.EventToDiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionThreadMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.DiscussionEventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MessagingDiscussionApplicationEventListener
implements ApplicationListener<DiscussionApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingDiscussionApplicationEventListener.class);
    private final DiscussionEventProducer discussionEventProducer;
    private final EventToDiscussionMapper eventToDiscussionMapper;

    public void onApplicationEvent(@NonNull DiscussionApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        MessagingEventDto messagingEventDto = this.eventToDiscussionMapper.toMessagingEventDto(event.getDiscussionThreadDetails());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        DiscussionThreadMessagingAdditionalDataDto additionalData = MessagingDiscussionApplicationEventListener.getDiscussionThreadMessagingAdditionalDataDto((DiscussionApplicationEvent)event);
        messagingEventDto.setAdditionalData((Object)additionalData);
        this.publishEventForType(event, messagingEventDto);
    }

    @NotNull
    private static DiscussionThreadMessagingAdditionalDataDto getDiscussionThreadMessagingAdditionalDataDto(@NotNull DiscussionApplicationEvent event) {
        DiscussionThreadDetails discussionThreadDetails = event.getDiscussionThreadDetails();
        DiscussionThreadMessagingAdditionalDataDto additionalData = new DiscussionThreadMessagingAdditionalDataDto();
        additionalData.setDiscussionResourceId(discussionThreadDetails.getDiscussionResourceId());
        additionalData.setDiscussionResourceType(discussionThreadDetails.getDiscussionResourceType());
        additionalData.setNotifyUserIds(discussionThreadDetails.getUsersToNotify());
        additionalData.setDiscussionId(discussionThreadDetails.getDiscussionId());
        additionalData.setDiscussionTitle(discussionThreadDetails.getDiscussionTitle());
        return additionalData;
    }

    private void publishEventForType(DiscussionApplicationEvent applicationEvent, MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> messagingEventDto) {
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$discussion$bs$enums$MessagingEventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                this.discussionEventProducer.publishCreateEvent(messagingEventDto);
            }
        }
    }

    @Generated
    public MessagingDiscussionApplicationEventListener(DiscussionEventProducer discussionEventProducer, EventToDiscussionMapper eventToDiscussionMapper) {
        this.discussionEventProducer = discussionEventProducer;
        this.eventToDiscussionMapper = eventToDiscussionMapper;
    }
}

