package com.finconsgroup.itserr.marketplace.discussion.bs;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.*;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * The entry point of the Discussion Backend Service (BS) application.
 * <p>
 * This class is annotated with {@code @SpringBootApplication}, which indicates a
 * Spring Boot application. It enables auto-configuration, scanning of Spring components,
 * and other configuration settings.
 * <p>
 * The class also uses {@code @EnableConfigurationProperties} annotation to bind and validate
 * the {@link DiscussionBsConfigurationProperties} class. This allows the application to inject
 * configuration values from external properties files into strongly-typed configuration objects.
 * <p>
 * The main method serves as the starting point for the application, bootstrapping it
 * using {@link SpringApplication#run(Class, String...)}.
 */
@SpringBootApplication
@EnableConfigurationProperties({DiscussionBsConfigurationProperties.class,
        NewsProperties.class, PiProperties.class, EventsProperties.class, ItemsProperties.class, FoldersProperties.class
        , DocumentsProperties.class})
public class DiscussionBsApplication {

    public static void main(String[] args) {
        SpringApplication.run(DiscussionBsApplication.class, args);
    }

}
