package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.impl;

import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.DiscussionEventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link DiscussionEventProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerDiscussionEventProducer implements DiscussionEventProducer {

    @Override
    public void publishCreateEvent(@NotNull MessagingEventDto<?> eventDto) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", eventDto);
    }

}