package com.finconsgroup.itserr.marketplace.discussion.bs.mapper;

import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto.DiscussionThreadMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-01-02T19:21:24+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class EventToDiscussionMapperImpl implements EventToDiscussionMapper {

    @Override
    public DiscussionDTO toDiscussionDTO(MessagingEventDto<DiscussionMessagingAdditionalDataDto> dto) {
        if ( dto == null ) {
            return null;
        }

        DiscussionDTO.DiscussionDTOBuilder discussionDTO = DiscussionDTO.builder();

        discussionDTO.title( mapTitle( dto ) );
        discussionDTO.content( dtoAdditionalDataContent( dto ) );
        discussionDTO.createdBy( dtoUserUsername( dto ) );
        discussionDTO.resourceId( stringToUuid( dto.getId() ) );
        discussionDTO.url( dtoAdditionalDataImageUrl( dto ) );
        String visibility = dtoAdditionalDataVisibility( dto );
        if ( visibility != null ) {
            discussionDTO.visibility( visibility );
        }
        else {
            discussionDTO.visibility( "public" );
        }

        discussionDTO.createdAt( java.time.Instant.now() );

        return discussionDTO.build();
    }

    @Override
    public DiscussionThreadDetails toDiscussionThreadDetails(ThreadDTO thread, DiscussionDTO discussion, Set<String> usersToNotify) {
        if ( thread == null && discussion == null && usersToNotify == null ) {
            return null;
        }

        DiscussionThreadDetails.DiscussionThreadDetailsBuilder discussionThreadDetails = DiscussionThreadDetails.builder();

        if ( thread != null ) {
            discussionThreadDetails.id( thread.getId() );
            discussionThreadDetails.timestamp( localDateTimeToInstant( thread.getCreatedAt() ) );
        }
        if ( discussion != null ) {
            discussionThreadDetails.discussionId( discussion.getId() );
            discussionThreadDetails.discussionTitle( discussion.getTitle() );
            discussionThreadDetails.discussionResourceId( discussion.getResourceId() );
            discussionThreadDetails.discussionResourceType( discussion.getResourceType() );
        }
        Set<String> set = usersToNotify;
        if ( set != null ) {
            discussionThreadDetails.usersToNotify( new LinkedHashSet<String>( set ) );
        }
        discussionThreadDetails.name( "Discussion Thread" );

        return discussionThreadDetails.build();
    }

    @Override
    public MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> toMessagingEventDto(DiscussionThreadDetails discussionThreadDetails) {
        if ( discussionThreadDetails == null ) {
            return null;
        }

        MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto> messagingEventDto = new MessagingEventDto<DiscussionThreadMessagingAdditionalDataDto>();

        messagingEventDto.setTitle( discussionThreadDetails.getDiscussionTitle() );
        if ( discussionThreadDetails.getId() != null ) {
            messagingEventDto.setId( discussionThreadDetails.getId().toString() );
        }
        messagingEventDto.setName( discussionThreadDetails.getName() );
        messagingEventDto.setTimestamp( discussionThreadDetails.getTimestamp() );

        return messagingEventDto;
    }

    private String dtoAdditionalDataContent(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionMessagingAdditionalDataDto additionalData = messagingEventDto.getAdditionalData();
        if ( additionalData == null ) {
            return null;
        }
        return additionalData.getContent();
    }

    private String dtoUserUsername(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        MessagingEventUserDto user = messagingEventDto.getUser();
        if ( user == null ) {
            return null;
        }
        return user.getUsername();
    }

    private String dtoAdditionalDataImageUrl(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionMessagingAdditionalDataDto additionalData = messagingEventDto.getAdditionalData();
        if ( additionalData == null ) {
            return null;
        }
        return additionalData.getImageUrl();
    }

    private String dtoAdditionalDataVisibility(MessagingEventDto<DiscussionMessagingAdditionalDataDto> messagingEventDto) {
        DiscussionMessagingAdditionalDataDto additionalData = messagingEventDto.getAdditionalData();
        if ( additionalData == null ) {
            return null;
        }
        return additionalData.getVisibility();
    }
}
