package com.finconsgroup.itserr.marketplace.discussion.bs.messaging;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.NewsProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.messaging.consumer.AbstractResourceSubscriber;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Slf4j
@Component("newsCreationSubscriber")
@RequiredArgsConstructor
public class NewsCreationSubscriber extends AbstractResourceSubscriber {

    private final CreationDiscussionUtility creationDiscussionUtility;
    private final NewsProperties newsProperties;

    @Override
    protected void handleResource(String id, Object eventData, String eventType) {
        if (Objects.equals(eventType, newsProperties.getResourceCreatedEventType())) {
            creationDiscussionUtility.create(id, eventData, ResourceType.NEWS.getValue());
        }
    }
}


