package com.finconsgroup.itserr.marketplace.discussion.dm.enums;

/**
 * Enumeration representing the different types of reactions that users can express
 * on discussions and threads.
 */
public enum ReactionType {
    /**
     * Represents a positive reaction indicating approval or agreement.
     */
    LIKE("like"),
    
    /**
     * Represents a celebratory reaction indicating joy or excitement.
     */
    CELEBRATE("celebrate"),
    
    /**
     * Represents a strong positive reaction indicating affection or strong approval.
     */
    LOVE("love"),
    
    /**
     * Represents a reaction indicating the content is insightful or enlightening.
     */
    INSIGHTFUL("insightful"),
    
    /**
     * Represents a reaction indicating curiosity or interest in learning more.
     */
    CURIOUS("curious");
    
    private final String value;
    
    ReactionType(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return value;
    }
}