package com.finconsgroup.itserr.marketplace.discussion.dm.mapper;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.DiscussionReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.ThreadReaction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-12-29T11:21:52+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class DiscussionMapperImpl extends DiscussionMapper {

    @Override
    public DiscussionDTO toDTO(Discussion discussion) {
        if ( discussion == null ) {
            return null;
        }

        DiscussionDTO.DiscussionDTOBuilder discussionDTO = DiscussionDTO.builder();

        discussionDTO.threads( mapThreadsToDTO( discussion.getThreads() ) );
        discussionDTO.id( discussion.getId() );
        discussionDTO.title( discussion.getTitle() );
        discussionDTO.content( discussion.getContent() );
        discussionDTO.createdBy( discussion.getCreatedBy() );
        discussionDTO.createdAt( discussion.getCreatedAt() );
        discussionDTO.resourceId( discussion.getResourceId() );
        discussionDTO.resourceType( discussion.getResourceType() );
        discussionDTO.visibility( discussion.getVisibility() );
        discussionDTO.url( discussion.getUrl() );
        discussionDTO.updatedBy( discussion.getUpdatedBy() );
        discussionDTO.updatedAt( discussion.getUpdatedAt() );
        discussionDTO.reactions( discussionReactionListToDiscussionReactionDTOList( discussion.getReactions() ) );

        DiscussionDTO discussionDTOResult = discussionDTO.build();

        afterDiscussionToDTO( discussion, discussionDTOResult );

        return discussionDTOResult;
    }

    @Override
    public DiscussionDTO toDTOWithoutThreads(Discussion discussion) {
        if ( discussion == null ) {
            return null;
        }

        DiscussionDTO.DiscussionDTOBuilder discussionDTO = DiscussionDTO.builder();

        discussionDTO.id( discussion.getId() );
        discussionDTO.title( discussion.getTitle() );
        discussionDTO.content( discussion.getContent() );
        discussionDTO.createdBy( discussion.getCreatedBy() );
        discussionDTO.createdAt( discussion.getCreatedAt() );
        discussionDTO.resourceId( discussion.getResourceId() );
        discussionDTO.resourceType( discussion.getResourceType() );
        discussionDTO.visibility( discussion.getVisibility() );
        discussionDTO.url( discussion.getUrl() );
        discussionDTO.updatedBy( discussion.getUpdatedBy() );
        discussionDTO.updatedAt( discussion.getUpdatedAt() );
        discussionDTO.reactions( discussionReactionListToDiscussionReactionDTOList( discussion.getReactions() ) );

        DiscussionDTO discussionDTOResult = discussionDTO.build();

        afterDiscussionToDTO( discussion, discussionDTOResult );

        return discussionDTOResult;
    }

    @Override
    public Discussion toEntity(DiscussionDTO discussionDTO) {
        if ( discussionDTO == null ) {
            return null;
        }

        Discussion.DiscussionBuilder discussion = Discussion.builder();

        discussion.id( discussionDTO.getId() );
        discussion.title( discussionDTO.getTitle() );
        discussion.content( discussionDTO.getContent() );
        discussion.createdBy( discussionDTO.getCreatedBy() );
        discussion.createdAt( discussionDTO.getCreatedAt() );
        discussion.resourceId( discussionDTO.getResourceId() );
        discussion.resourceType( discussionDTO.getResourceType() );
        discussion.visibility( discussionDTO.getVisibility() );
        discussion.url( discussionDTO.getUrl() );
        discussion.updatedBy( discussionDTO.getUpdatedBy() );
        discussion.updatedAt( discussionDTO.getUpdatedAt() );

        return discussion.build();
    }

    @Override
    public ThreadDTO mapThreadToDTO(Thread thread) {
        if ( thread == null ) {
            return null;
        }

        ThreadDTO.ThreadDTOBuilder threadDTO = ThreadDTO.builder();

        threadDTO.parentId( threadParentId( thread ) );
        threadDTO.id( thread.getId() );
        threadDTO.createdBy( thread.getCreatedBy() );
        threadDTO.createdAt( thread.getCreatedAt() );
        threadDTO.modifiedAt( thread.getModifiedAt() );
        threadDTO.content( thread.getContent() );
        threadDTO.replies( mapThreadRepliesToDTO( thread.getReplies() ) );
        threadDTO.reactions( threadReactionListToThreadReactionDTOList( thread.getReactions() ) );

        ThreadDTO threadDTOResult = threadDTO.build();

        afterThreadToDTO( thread, threadDTOResult );

        return threadDTOResult;
    }

    @Override
    public ThreadReactionDTO mapThreadReactionToDTO(ThreadReaction reaction) {
        if ( reaction == null ) {
            return null;
        }

        ThreadReactionDTO.ThreadReactionDTOBuilder threadReactionDTO = ThreadReactionDTO.builder();

        threadReactionDTO.id( reaction.getId() );
        threadReactionDTO.userId( reaction.getUserId() );
        threadReactionDTO.reaction( reaction.getReaction() );
        threadReactionDTO.createdAt( reaction.getCreatedAt() );

        return threadReactionDTO.build();
    }

    @Override
    public DiscussionReactionDTO mapDiscussionReactionToDTO(DiscussionReaction reaction) {
        if ( reaction == null ) {
            return null;
        }

        DiscussionReactionDTO.DiscussionReactionDTOBuilder discussionReactionDTO = DiscussionReactionDTO.builder();

        discussionReactionDTO.id( reaction.getId() );
        discussionReactionDTO.userId( reaction.getUserId() );
        discussionReactionDTO.reaction( reaction.getReaction() );
        discussionReactionDTO.createdAt( reaction.getCreatedAt() );

        return discussionReactionDTO.build();
    }

    protected List<DiscussionReactionDTO> discussionReactionListToDiscussionReactionDTOList(List<DiscussionReaction> list) {
        if ( list == null ) {
            return null;
        }

        List<DiscussionReactionDTO> list1 = new ArrayList<DiscussionReactionDTO>( list.size() );
        for ( DiscussionReaction discussionReaction : list ) {
            list1.add( mapDiscussionReactionToDTO( discussionReaction ) );
        }

        return list1;
    }

    private UUID threadParentId(Thread thread) {
        Thread parent = thread.getParent();
        if ( parent == null ) {
            return null;
        }
        return parent.getId();
    }

    protected List<ThreadReactionDTO> threadReactionListToThreadReactionDTOList(List<ThreadReaction> list) {
        if ( list == null ) {
            return null;
        }

        List<ThreadReactionDTO> list1 = new ArrayList<ThreadReactionDTO>( list.size() );
        for ( ThreadReaction threadReaction : list ) {
            list1.add( mapThreadReactionToDTO( threadReaction ) );
        }

        return list1;
    }
}
