package com.finconsgroup.itserr.marketplace.event.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

/**
 * Output DTO for subscribed participant.
 */
@Schema(name = "OutputSubscribedParticipantDto", description = "DTO representing a subscribed participant in responses")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class OutputSubscribedParticipantDto extends com.finconsgroup.itserr.marketplace.event.dm.dto.OutputSubscribedParticipantDto {

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;
}
