package com.finconsgroup.itserr.marketplace.event.bs.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.SchemaProperties;
import io.swagger.v3.oas.annotations.media.SchemaProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

/**
 * Output DTO representing a created event.
 */
@Schema(name = "OutputEventDto", description = "DTO representing a event in responses")
@SchemaProperties({
        @SchemaProperty(
                name = "institutionalPageIds",
                schema = @Schema(accessMode = Schema.AccessMode.WRITE_ONLY) // set to write only to hide on response
        ),
        @SchemaProperty(
                name = "subscribedParticipants",
                schema = @Schema(implementation = OutputSubscribedParticipantDto.class)
        ),
        @SchemaProperty(
                name = "eventPlannerId",
                schema = @Schema(accessMode = Schema.AccessMode.WRITE_ONLY)
        ),
        @SchemaProperty(
                name = "maintainerId",
                schema = @Schema(accessMode = Schema.AccessMode.WRITE_ONLY)
        )
})
@JsonIgnoreProperties(value = {"institutionalPageIds", "eventPlannerId", "maintainerId"},
        ignoreUnknown = true)
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class OutputEventDto extends com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto {

    @Schema(description = "The event planner user details")
    private OutputUserProfileDto eventPlanner;

    @Schema(description = "The maintainer details")
    private OutputUserProfileDto maintainer;
}
