package com.finconsgroup.itserr.marketplace.event.bs.client.dto.institutionalpage;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Set;
import java.util.UUID;

/**
 * Input DTO for searching institutionalPages.
 */
@Schema(name = "InputSearchInstitutionalPageDto", description = "Input DTO for searching institutionalPages")
@Data
@Builder
@AllArgsConstructor
public class InputSearchInstitutionalPageDto {

    /**
     * Filter to only return institutional pages matching the provided ids.
     */
    @Schema(
            description = "The ids of the institutional page, if present it should have at least one entry",
            example = "[\"11111111-aaaa-0000-0000-000000000000\"]"
    )
    @Size(min = 1)
    private List<UUID> ids;

    /**
     * Filter to only return institutional pages matching the provided category
     */
    @Schema(
            description = "The category of the institutional page",
            allowableValues = {"tool", "project"},
            example = "project"
    )
    private String category;

    /**
     * Filter to only return root level i.e. top level institutional pages
     */
    @Schema(
            description = "The flag to indicate if only top level institutional pages should be returned",
            example = "true"
    )
    private Boolean rootLevel;

    /**
     * The associations that should be returned on the response.
     */
    @Schema(
            description = "The associations to load for the institutional page",
            allowableValues = {"parent", "wpLeads", "contributors", "childInstitutionalPages", "paragraphs"},
            example = "[\"parent\", \"wpLeads\", \"contributors\"]"
    )
    private Set<String> associationsToLoad;
}
