package com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(
        name = "FolderD4SDto",
        description = "Represents a folder inside a workspace, extending ItemDto"
)
public class FolderDto {

    @Schema(description = "Unique identifier of the item", example = "7033aad8-3519-44a0-ab44-9999999")
    private String id;

}
