package com.finconsgroup.itserr.marketplace.event.bs.validation.annotation;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Pattern;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Meta annotation to apply regex pattern for associations to load input parameter.
 */
@Documented
@Constraint(validatedBy = {})
@Target({ElementType.TYPE_USE, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Pattern(regexp = "all|eventConductors|schedules|programs|subscribedParticipants")
public @interface ValidAssociationToLoad {

    String message() default "Allowed values: 'all', 'eventConductors', 'schedules', 'programs', 'subscribedParticipants'";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}