package com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.net.URI;

/**
 * A document represent image that can be accessed publicly.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "PublicImage",
        description = "Represents an image document that can be accessed publicly"
)
public class OutputPublicImageWSDto {

    @Schema(
            description = "Document Id",
            example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(description = "Public Link (can be null in case of update if new image document was not created)")
    private URI publicLink;

}
