package com.finconsgroup.itserr.marketplace.event.bs.messaging;


import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing news-related resource messages
 */
public interface EventProducer {

    /**
     * Publishes an Event message for created resource.
     *
     * @param eventDto the resource that was created
     */
    void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message for updated resource.
     *
     * @param eventDto the resource that was updated
     */
    void publishUpdateEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message for deleted resource.
     *
     * @param eventDto the resource that was deleted
     */
    void publishDeleteEvent(@NonNull MessagingEventDto<?> eventDto);

    /**
     * Publishes an Event message when user subscribe/unsubscribe to an Event.
     *
     * @param eventDto the resource with status details
     */
    void publishSubscriptionEvent(@NonNull MessagingEventDto<?> eventDto);

}
