package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Input DTO for program subscribed participant.
 */
@Schema(name = "InputProgramSubscribedParticipantDto", description = "DTO representing a program subscribed participant request")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputProgramSubscribedParticipantDto {

    @Schema(description = "True, if the participant is attending remotely (online)", example = "false")
    private Boolean remoteParticipation;
}
