package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.LONG_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;

/**
 * Input DTO for schedule of an event.
 */
@Schema(name = "InputScheduleDto", description = "DTO for schedule")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputScheduleDto {

    @Schema(description = "The title of the schedule", example = "Day 1")
    @NotBlank
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String title;

    @Schema(description = "The description of the schedule", example = "Day 1 of Annual Tech Conference 2025")
    @Size(max = LONG_TEXT_LENGTH)
    private String description;

    @Schema(description = "The start date of the schedule", example = "2025-06-18")
    @NotNull
    private LocalDate startDate;

    @Schema(description = "The start time of the schedule", example = "10:30:00")
    @NotNull
    private LocalTime startTime;

    @Schema(description = "The end time of the schedule", example = "15:30:00")
    @NotNull
    private LocalTime endTime;

    @Schema(description = "The location of the schedule")
    @Valid
    private InputLocationDto location;

    @Schema(description = "The programs of the schedule")
    @Valid
    private List<InputProgramDto> programs;
}
