package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO representing a created event.
 */
@Schema(name = "OutputEventDto", description = "DTO representing a event in responses")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputEventDto {

    @Schema(description = "Unique identifier of the event", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The title of the event", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The link for the event", example = "https://meeting.example.com/test123")
    private String eventLink;

    @Schema(description = "The type of event", example = "webinar")
    private String eventType;

    @Schema(description = "The content of the event", example = "Join us for the biggest tech conference of the year...")
    private String content;

    @Schema(description = "The number of participants subscribed for the event", example = "10")
    private Integer subscribedParticipantsCount;

    @Schema(description = "List of tags associated with the event", example = "[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<OutputInstitutionalPageDto> institutionalPages;

    @Schema(description = "The image for the event")
    private OutputImageDto image;

    @Schema(description = "The timezone for the event", example = "Europe/Rome")
    private String timezone;

    @Schema(description = "The start date for the event based on schedules", example = "2025-06-18")
    private LocalDate startDate;

    @Schema(description = "The end date for the event based on schedules", example = "2025-06-20")
    private LocalDate endDate;

    @Schema(description = "The event conductors")
    private List<OutputEventConductorDto> eventConductors;

    @Schema(description = "The event schedules")
    private List<OutputScheduleDto> schedules;

    @Schema(description = "List of subscribed participants")
    private List<OutputSubscribedParticipantDto> subscribedParticipants;

    @Schema(description = "The event planner user id")
    private UUID eventPlannerId;

    @Schema(description = "The maintainer id")
    private UUID maintainerId;

    @Schema(description = "True, if user is subscribed to the event")
    private Boolean subscribed;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;
}
