package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;

/**
 * Input DTO for institutional page.
 */
@Schema(name = "InputInstitutionalPageDto", description = "DTO for institutional page")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputInstitutionalPageDto {

    @Schema(description = "The ID of the institutional page", example = "fd4d1ff4-16c5-4468-83fc-454881f73134")
    @NotNull
    private UUID id;

    @Schema(description = "The name of the institutional page", example = "WP3 - T-Res")
    @NotBlank
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String name;
}
