package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.UUID;

/**
 * Output DTO for institutional page.
 */
@Schema(name = "OutputInstitutionalPageDto", description = "DTO for institutional page response")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputInstitutionalPageDto {

    @Schema(description = "The ID of the institutional page", example = "fd4d1ff4-16c5-4468-83fc-454881f73134")
    private UUID id;

    @Schema(description = "The name of the institutional page", example = "WP3 - T-Res")
    private String name;
}
