package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ScheduleEntity;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

import java.util.List;

@Mapper(config = MapperConfiguration.class, uses = {ProgramMapper.class})
public interface ScheduleMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "locationCity", source = "location.city")
    @Mapping(target = "locationRegion", source = "location.region")
    @Mapping(target = "locationCountry", source = "location.country")
    @Mapping(target = "locationZipCode", source = "location.zipCode")
    @Mapping(target = "event", ignore = true)
    @Mapping(target = "eventId", ignore = true)
    @Mapping(target = "scheduleOrder", ignore = true)
    ScheduleEntity toEntity(InputScheduleDto inputScheduleDto);

    List<ScheduleEntity> toEntityList(List<InputScheduleDto> inputScheduleDto);

    @Mapping(target = "location.city", source = "locationCity")
    @Mapping(target = "location.region", source = "locationRegion")
    @Mapping(target = "location.country", source = "locationCountry")
    @Mapping(target = "location.zipCode", source = "locationZipCode")
    OutputScheduleDto toDto(ScheduleEntity scheduleEntity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "locationCity", source = "location.city")
    @Mapping(target = "locationRegion", source = "location.region")
    @Mapping(target = "locationCountry", source = "location.country")
    @Mapping(target = "locationZipCode", source = "location.zipCode")
    @Mapping(target = "event", ignore = true)
    @Mapping(target = "eventId", ignore = true)
    @Mapping(target = "scheduleOrder", ignore = true)
    @Mapping(target = "programs", ignore = true) // will be set manually
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputScheduleDto dto, @MappingTarget ScheduleEntity scheduleEntity);

}
