package com.finconsgroup.itserr.marketplace.event.dm.repository;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * {@link ProgramRepository} repository.
 */
@Repository
public interface ProgramRepository extends JpaRepository<ProgramEntity, UUID> {

    /**
     * Retrieves the programs for provided event ids
     *
     * @param eventIds the unique identifier of the events to be retrieved
     * @return an {@link List} containing the matching {@link ProgramEntity}s if found, or an empty {@link List} if no match exists
     */
    List<ProgramEntity> findAllByScheduleEventIdIn(List<UUID> eventIds);

    /**
     * checks if a program exists for an event
     *
     * @param eventId   the id of the event
     * @param programId the unique identifier of a program
     */
    Optional<ProgramEntity> findByIdAndScheduleEventId(UUID programId, UUID eventId);
}
