package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedEventEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.EventEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class,
        uses = {ArchivedSubscribedParticipantMapper.class,
                ArchivedProgramConductorMapper.class,
                ArchivedProgramSubscribedParticipantMapper.class})
public interface ArchivedEventMapper {

    /**
     * Maps a {@link EventEntity} into a {@link ArchivedEventEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "archiveTime", ignore = true)
    ArchivedEventEntity toArchivedEntity(EventEntity src);
}
