package com.finconsgroup.itserr.marketplace.event.dm.util;

import java.time.LocalDate;
import java.time.LocalTime;

/**
 * Utility class for date time related functions
 */
public final class DateTimeUtils {

    /**
     * Returns the minimum of the two dates provided
     *
     * @param date1 the first date to check
     * @param date2 the second date to check
     * @return the minimum @{@link LocalDate} found
     */
    public static LocalDate min(LocalDate date1, LocalDate date2) {
        if (date1 == null) {
            return date2;
        } else if (date2 == null) {
            return date1;
        } else {
            return date1.isBefore(date2) ? date1 : date2;
        }
    }

    /**
     * Returns the maximum of the two dates provided
     *
     * @param date1 the first date to check
     * @param date2 the second date to check
     * @return the maximum @{@link LocalDate} found
     */
    public static LocalDate max(LocalDate date1, LocalDate date2) {
        if (date1 == null) {
            return date2;
        } else if (date2 == null) {
            return date1;
        } else {
            return date1.isAfter(date2) ? date1 : date2;
        }
    }

    /**
     * Returns the minimum of the two times provided
     *
     * @param time1 the first time to check
     * @param time2 the second time to check
     * @return the minimum @{@link LocalTime} found
     */
    public static LocalTime min(LocalTime time1, LocalTime time2) {
        if (time1 == null) {
            return time2;
        } else if (time2 == null) {
            return time1;
        } else {
            return time1.isBefore(time2) ? time1 : time2;
        }
    }

    /**
     * Returns the maximum of the two times provided
     *
     * @param time1 the first time to check
     * @param time2 the second time to check
     * @return the maximum @{@link LocalTime} found
     */
    public static LocalTime max(LocalTime time1, LocalTime time2) {
        if (time1 == null) {
            return time2;
        } else if (time2 == null) {
            return time1;
        } else {
            return time1.isAfter(time2) ? time1 : time2;
        }
    }
}
