package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.entity.ArchivedProgramSubscribedParticipantEntity;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramSubscribedParticipantEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface ArchivedProgramSubscribedParticipantMapper {

    /**
     * Maps a {@link ProgramSubscribedParticipantEntity} into a {@link ArchivedProgramSubscribedParticipantEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "archiveTime", ignore = true)
    @Mapping(target = "program", ignore = true)
    ArchivedProgramSubscribedParticipantEntity toArchivedProgramSubscribedParticipantEntity(ProgramSubscribedParticipantEntity src);
}
