package com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.favouritesearch.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.favouritesearch.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for creating a favouriteSearchEntry.
 */
@Schema(name = "InputCreateFavouriteSearch", description = "DTO for creating a favouriteSearch")
@Data
@Builder
@AllArgsConstructor
public class InputCreateFavouriteSearchDto {
    @Schema(description = "The name of the favourite search", example = "My favourite search")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String name;

    @Schema(description = "The context of the favourite search", example = "items")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private SearchContext context;

    @Schema(description = "The text used to perform the search", example = "Godfath")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String searchText;

    @Schema(description = "Raw filters of the search provided by the frontend")
    private List<@Valid SearchFilterFavouriteSearchDto> searchFilters;
}
