package com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import static com.finconsgroup.itserr.marketplace.favouritesearch.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SearchFilterFavouriteSearchDto {
    @Schema(description = "The key of the filter", example = "type")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private String key;
    @Schema(description = "The value of the filter", example = "dataset")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private String value;
}
