package com.finconsgroup.itserr.marketplace.favouritesearch.dm.repository;

import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.FavouriteSearchEntity;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

/**
 * {@link FavouriteSearchRepository} repository.
 */
@Repository
public interface FavouriteSearchRepository extends JpaRepository<FavouriteSearchEntity, UUID> {

    Optional<FavouriteSearchEntity> findByUserIdAndId(UUID userId, UUID id);

    Page<FavouriteSearchEntity> findAllByUserId(UUID userId, Pageable pageable);

    Page<FavouriteSearchEntity> findAllByUserIdAndSearchTextContainingIgnoreCaseOrUserIdAndNameContainingIgnoreCase(
            UUID userIdForSearchText,
            String searchText,
            UUID userIdForName,
            String name,
            Pageable pageable
    );

    Page<FavouriteSearchEntity> findAllByUserIdAndContextAndSearchTextContainingIgnoreCaseOrUserIdAndContextAndNameContainingIgnoreCase(
            UUID userIdForSearchText,
            SearchContext contextForSearch,
            String searchText,
            UUID userIdForName,
            SearchContext contextForName,
            String name,
            Pageable pageable
    );

    /**
     * Finds the favourite search item for provided context.
     *
     * @param context  the context to search for
     * @param pageable the page request
     * @return the found page of favourite search item results
     */
    Page<FavouriteSearchEntity> findByUserIdAndContext(@NonNull UUID userId, @NonNull SearchContext context, Pageable pageable);
}