package com.finconsgroup.itserr.marketplace.favourite.user.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.converter.ItemContextAttributeConverter;
import com.finconsgroup.itserr.marketplace.favourite.user.dm.enums.ItemContext;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.favourite.user.dm.util.DomainConstants.CONTEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.favourite.user.dm.util.DomainConstants.ITEM_ID_LENGTH;
import static com.finconsgroup.itserr.marketplace.favourite.user.dm.util.DomainConstants.SUB_CONTEXT_LENGTH;

/**
 * This entity represents an archived favourite user item.
 */
@Entity
@Table(name = "archived_favourite_user_item")
@SuperBuilder
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class ArchivedFavouriteUserItemEntity extends AbstractUUIDEntity {

    /**
     * Item User id.
     */
    @Column(name = "user_id", nullable = false, updatable = false)
    private UUID userId;

    /**
     * Item context.
     */
    @Column(name = "context", nullable = false, updatable = false, length = CONTEXT_LENGTH)
    @Convert(converter = ItemContextAttributeConverter.class)
    private ItemContext context;

    /**
     * Item sub context.
     */
    @Column(name = "sub_context", length = SUB_CONTEXT_LENGTH)
    private String subContext;

    /**
     * Identifier of the referenced item.
     */
    @Column(name = "item_id", nullable = false, length = ITEM_ID_LENGTH)
    private String itemId;

    /**
     * Flag to indicate if the item has been followed by the user.
     */
    @Column(name = "followed", nullable = false)
    private boolean followed;

    /**
     * Creation timestamp
     */
    @Column(name = "creation_time", nullable = false)
    private Instant creationTime;

    /**
     * Update timestamp
     */
    @Column(name = "update_time", nullable = false)
    private Instant updateTime;

    /**
     * Archival timestamp
     */
    @Column(name = "archival_time", nullable = false)
    private Instant archivalTime;

    /**
     * The version that was deleted.
     */
    @Column(name = "version", nullable = false)
    private long version;

    @Override
    public void prePersist() {
        super.prePersist();
        archivalTime = Instant.now();
    }
}
