package com.finconsgroup.itserr.marketplace.favourite.user.dm.enums;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Enumeration for all supported context values for favourite user items.
 */
public enum ItemContext {
    CATALOG("catalog"), INSTITUTIONAL_PAGE("institutional-page"), SEARCH("search"), LABEL("label"), TOOL("tool"), PEOPLE("people");

    private final String id;

    ItemContext(String id) {
        this.id = id;
    }

    /**
     * Returns the id of the item context.
     *
     * @return string id
     */
    @JsonValue
    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return id;
    }

    /**
     * It maps the name to a {@link ItemContext} object
     *
     * @param id the id to map to item context
     * @return {@link ItemContext} instance if found
     * @throws IllegalArgumentException if no matching category instance found
     */
    public static ItemContext ofId(String id) {
        for (ItemContext itemContext : ItemContext.values()) {
            if (itemContext.id.equalsIgnoreCase(id)) {
                return itemContext;
            }
        }

        throw new IllegalArgumentException("Unsupported item context : " + id);
    }


}
