package com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.OutputItemDtoWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CreateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.OutputRequestUpdateDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UpdateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputPublicationDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputWorkspaceItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.CatalogRepository;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.UserProfileRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Component
@RequiredArgsConstructor
public class InstitutionalPageMapper {
    private final InstitutionalPagePartialMapper partialMapper;

    private final UserProfileRepository userProfileRepository;
    private final CatalogRepository catalogRepository;

    public CreateInstitutionalPageIPDmDto toCreateInstitutionalPageDmDto(InputCreateInstitutionalPageDto dto, UUID workspaceFolderId) {
        CreateInstitutionalPageIPDmDto dmDto = partialMapper.toCreateInstitutionalPageDmDto(dto);
        dmDto.setWorkspaceFolderId(workspaceFolderId);

        return dmDto;
    }

    public CreateInstitutionalPageIPDmDto toCreateInstitutionalPageDmDto(InputCreateInstitutionalPageDto dto, UUID workspaceFolderId, String imageUrl) {
        CreateInstitutionalPageIPDmDto dmDto = partialMapper.toCreateInstitutionalPageDmDto(dto);
        dmDto.setWorkspaceFolderId(workspaceFolderId);
        dmDto.setImageUrl(imageUrl);

        return dmDto;
    }

    public UpdateInstitutionalPageIPDmDto toUpdateInstitutionalPageDmDto(InputUpdateInstitutionalPageDto dto, String imageUrl) {
        UpdateInstitutionalPageIPDmDto dmDto = partialMapper.toUpdateInstitutionalPageDmDto(dto);
        dmDto.setImageUrl(imageUrl);

        return dmDto;
    }

    public OutputInstitutionalPageDto toOutputInstitutionalPageDto(InstitutionalPageIPDmDto dto,
                                                                   boolean withPublications) {
        OutputInstitutionalPageDto outputDto = partialMapper.toOutputInstitutionalPageDto(dto);
        // Retrieve the user profiles of the members
        List<OutputUserProfileDto> memberProfiles = userProfileRepository.getMemberProfilesOrThrow(dto.getMembers());
        // Retrieve the user profiles of the wp leads
        List<OutputUserProfileDto> wpLeadsProfiles = userProfileRepository.getMemberProfilesOrThrow(dto.getWpLeads());
        // Retrieve the user profile of the maintainer
        OutputUserProfileDto maintainer = null;
        if (dto.getMaintainer() != null)
            maintainer = userProfileRepository.getMemberProfilesOrThrow(List.of(dto.getMaintainer())).getFirst();
        // Retrieve the user profile of the updateLockedBy
        OutputUserProfileDto updateLockedBy = null;
        if (dto.getUpdateLockedBy() != null) {
            updateLockedBy = userProfileRepository.getMemberProfilesOrThrow(List.of(dto.getUpdateLockedBy())).getFirst();
        }
        // Retrieve the user profile of the lastModifiedBy
        OutputUserProfileDto lastModifiedBy = null;
        if (dto.getLastModifiedBy() != null)
            lastModifiedBy = userProfileRepository.getMemberProfilesOrThrow(List.of(dto.getLastModifiedBy())).getFirst();
        // Retrieve the list of publications
        List<OutputPublicationDto> publications = List.of();
        if (withPublications) {
            publications = catalogRepository.getPublications(dto.getId());
        }

        outputDto.setMembers(memberProfiles);
        outputDto.setWpLeads(wpLeadsProfiles);
        outputDto.setMaintainer(maintainer);
        outputDto.setUpdateLockedBy(updateLockedBy);
        outputDto.setLastModifiedBy(lastModifiedBy);
        outputDto.setPublications(publications);

        return outputDto;
    }

    public OutputPageDto<OutputInstitutionalPageDto> toOutputPageDto(OutputPageDto<InstitutionalPageIPDmDto> dto) {
        return toOutputPageDto(dto, true);
    }

    public OutputPageDto<OutputInstitutionalPageDto> toOutputPageDto(
            OutputPageDto<InstitutionalPageIPDmDto> dto,
            boolean withPublications
    ) {
        List<OutputInstitutionalPageDto> institutionalPages = new ArrayList<>();
        for (InstitutionalPageIPDmDto institutionalPageDmDto: dto.getContent()) {
            institutionalPages.add(
                    this.toOutputInstitutionalPageDto(institutionalPageDmDto, withPublications)
            );
        }

        OutputPageDto<OutputInstitutionalPageDto> outputPage = new OutputPageDto<>();
        outputPage.setContent(institutionalPages);
        outputPage.setPage(dto.getPage());

        return outputPage;
    }

    public OutputWorkspaceItemDto toOutputWorkspaceItemDto(OutputItemDtoWorkspaceBsDto src) {
        return partialMapper.toOutputWorkspaceItemDto(src);
    }

    public OutputRequestUpdateDto toOutputRequestUpdateDto(OutputRequestUpdateDmDto src) {
        return partialMapper.toOutputRequestUpdateDto(src);
    }

}
