package com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.PublishedInstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.PublishedInstitutionalPageService;
import feign.FeignException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.Set;
import java.util.UUID;

@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultPublishedInstitutionalPageService implements PublishedInstitutionalPageService {
    private final InstitutionalPageMapper institutionalPageMapper;
    private final PublishedInstitutionalPageDmClient institutionalPageDmClient;

    @Override
    public OutputPageDto<OutputInstitutionalPageDto> getAllPublishedInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction, boolean withPublications) {
        try {
            OutputPageDto<InstitutionalPageIPDmDto> institutionalPagesDmDto = institutionalPageDmClient.getAllPublishedInstitutionalPages(
                    associationsToLoad, pageNumber, pageSize, sort, direction);

            return institutionalPageMapper.toOutputPageDto(institutionalPagesDmDto, withPublications);
        } catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e);
        } catch (FeignException e) {
            throw new WP2BusinessException(e);
        }
    }

    @Override
    public OutputInstitutionalPageDto getPublishedInstitutionalPageById(UUID institutionalPageId, boolean withPublications) {
        try {
            InstitutionalPageIPDmDto institutionalPageDmDto = institutionalPageDmClient.getPublishedInstitutionalPageById(institutionalPageId);

            return institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, withPublications);
        } catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException(e);
        } catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e);
        } catch (FeignException e) {
            throw new WP2BusinessException(e);
        }
    }

    @NonNull
    @Override
    public OutputPageDto<OutputInstitutionalPageDto> search(@NonNull InputSearchPublishedInstitutionalPageDto inputSearchInstitutionalPageDto,
                                                            Set<String> associationsToLoad, int pageNumber, int pageSize,
                                                            String sort, SortDirection direction, boolean withPublications) {
        OutputPageDto<InstitutionalPageIPDmDto> institutionalPagesDmDto = institutionalPageDmClient.searchPublished(
                inputSearchInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction
        );

        return institutionalPageMapper.toOutputPageDto(institutionalPagesDmDto, withPublications);
    }
}
