/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.CreateDocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.CreateFolderWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentPublicLinkWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.DocumentWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.OutputItemDtoWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.ShareFolderWorkspaceBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.WorkspaceIdWorkspaceBsDto;
import java.util.List;
import java.util.UUID;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface WorkspaceBsClient {
    @GetMapping(path={"/workspace"}, produces={"application/json"})
    public WorkspaceIdWorkspaceBsDto getWorkspace();

    @PostMapping(path={"/workspace/folders/{parentFolderId}/folders"})
    public String createFolder(@PathVariable UUID var1, @RequestBody CreateFolderWorkspaceBsDto var2);

    @PostMapping(path={"/workspace/folders/{folderId}/share-users"})
    public void shareFolder(@PathVariable UUID var1, @RequestBody ShareFolderWorkspaceBsDto var2);

    @DeleteMapping(path={"/workspace/folders/{folderId}/share-users"})
    public String unshareFolder(@PathVariable UUID var1, @RequestBody List<String> var2);

    @PostMapping(path={"/workspace/folders/{folderId}/documents"}, consumes={"application/json"}, produces={"application/json"})
    public DocumentWorkspaceBsDto createEmptyDocument(@PathVariable(name="folderId") UUID var1, @RequestBody CreateDocumentWorkspaceBsDto var2);

    @GetMapping(path={"/workspace/documents/{documentId}/publiclink"}, produces={"application/json"})
    public DocumentPublicLinkWorkspaceBsDto getDocumentPublicLink(@PathVariable(name="documentId") UUID var1);

    @GetMapping(path={"workspace/folders/{folderId}/children"}, produces={"application/json"})
    public List<OutputItemDtoWorkspaceBsDto> getWorkspaceChildrenByFolderId(@PathVariable String var1, @RequestParam(name="pageNo") Integer var2, @RequestParam(name="pageSize") Integer var3);
}

