/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.PublishedInstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.PublishedInstitutionalPageService;
import feign.FeignException;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultPublishedInstitutionalPageService
implements PublishedInstitutionalPageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPublishedInstitutionalPageService.class);
    private final InstitutionalPageMapper institutionalPageMapper;
    private final PublishedInstitutionalPageDmClient institutionalPageDmClient;

    public OutputPageDto<OutputInstitutionalPageDto> getAllPublishedInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction, boolean withPublications) {
        try {
            OutputPageDto institutionalPagesDmDto = this.institutionalPageDmClient.getAllPublishedInstitutionalPages(associationsToLoad, pageNumber, pageSize, sort, direction);
            return this.institutionalPageMapper.toOutputPageDto(institutionalPagesDmDto, withPublications);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto getPublishedInstitutionalPageById(UUID institutionalPageId, boolean withPublications) {
        try {
            InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.getPublishedInstitutionalPageById(institutionalPageId);
            return this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, withPublications);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NonNull
    public OutputPageDto<OutputInstitutionalPageDto> search(@NonNull InputSearchPublishedInstitutionalPageDto inputSearchInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction, boolean withPublications) {
        OutputPageDto institutionalPagesDmDto = this.institutionalPageDmClient.searchPublished(inputSearchInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction);
        return this.institutionalPageMapper.toOutputPageDto(institutionalPagesDmDto, withPublications);
    }

    @Generated
    public DefaultPublishedInstitutionalPageService(InstitutionalPageMapper institutionalPageMapper, PublishedInstitutionalPageDmClient institutionalPageDmClient) {
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageDmClient = institutionalPageDmClient;
    }
}

