/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties.InstitutionalPageBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.InstitutionalPageProducer;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultInstitutionalPageProducer
implements InstitutionalPageProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultInstitutionalPageProducer.class);
    private final MessageProducer messageProducer;
    private final InstitutionalPageBsConfigurationProperties.Messaging messagingProperties;

    public DefaultInstitutionalPageProducer(InstitutionalPageBsConfigurationProperties institutionalPageBsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = institutionalPageBsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getInstitutionalPageProducerName());
    }

    public void publishCreateEvent(OutputInstitutionalPageDto institutionalPage) {
        this.publish(institutionalPage, this.messagingProperties.getInstitutionalPageCreatedType());
    }

    public void publishUpdateEvent(OutputInstitutionalPageDto institutionalPage) {
        this.publish(institutionalPage, this.messagingProperties.getInstitutionalPageUpdatedType());
    }

    public void publishDeleteEvent(OutputInstitutionalPageDto institutionalPage) {
        this.publish(institutionalPage, this.messagingProperties.getInstitutionalPageDeletedType());
    }

    private void publish(@NonNull OutputInstitutionalPageDto institutionalPage, @NonNull String eventType) {
        try {
            Map<String, OutputInstitutionalPageDto> messageMap = Map.of(institutionalPage.getId().toString(), institutionalPage);
            Map<String, String> filterProperties = Map.of("service", "institutional-page");
            log.debug("Sending message, messageMap: %s, eventType: %s, source: %s, filterProperties: %s".formatted(messageMap, eventType, this.messagingProperties.getSource(), filterProperties));
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published event message for resource with id: %s".formatted(institutionalPage.getId()));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

