package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output Dto of a button related to the institutional page.
 */
@Schema(name = "OutputButtonDto", description = "Output DTO of a button related to the institutional page")
@Data
@Builder
@AllArgsConstructor
public class OutputButtonDto {

    @Schema(description = "The label of the button", example = "Download Criterion")
    private String label;

    @Schema(description = "The action link of the button", example = "https://www.google.com/")
    private String link;

    @Schema(description = "The type of the button, used to determine its behavior.", example = "Download")
    private String buttonType;

    @Schema(description = "CSS class name for the icon displayed inside the button", example = "fa-download")
    private String iconCssClass;

}
