package com.finconsgroup.itserr.marketplace.institutional_page.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO of supported operating systems for the institutional page.
 */
@Schema(
        name = "OutputSupportedOsDto",
        description = "Output DTO of supported operating systems for the institutional page"
)
@Data
@Builder
@AllArgsConstructor
public class OutputSupportedOsDto {

    @Schema(description = "The supported macOS version or description.", example = "macOS 12+ supported")
    private String macOs;

    @Schema(description = "The supported linux version or description.", example = "Ubuntu 20.04+")
    private String linux;

    @Schema(description = "The supported windows version or description.", example = "Windows 10+ supported")
    private String windows;

}
