package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;


/**
 * Input DTO for updating user membership between WP Leader and regular member.
 */
@Schema(name = "InputPatchMembershipDto", description = "Input DTO for updating user membership between WP Leader and regular member")
@Data
@Builder
@AllArgsConstructor
public class InputPatchMembershipDto {

    @Schema(
            description = "ID of user to update membership",
            example = "33333333-aaaa-1111-0000-000000000000"
    )
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private UUID userId;

    @Schema(
            description = "Specify whether update membership to wp leader or regular member",
            example = "true"
    )
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private Boolean wpLeader;

}
