package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * Output DTO of a member with association for each institutional page of a given hierarchy.
 */
@Data
@Builder
@AllArgsConstructor
@Schema(
        name = "OutputMembersInHierarchyDto",
        description = "Output DTO of a member with association for each institutional page of a given hierarchy"
)
public class OutputMembersInHierarchyDto {

    @Schema(
            description = "ID of user belonging to the institutional page hierarchy",
            example = "33333333-aaaa-1111-0000-000000000000"
    )
    private UUID userId;

    @Schema(description = "The root institutional page")
    private OutputInstitutionalPageDto rootInstitutionalPage;

    @Schema(description = "DTO containing institutional page id and membership type for a specific member")
    private List<OutputInstitutionalPageForMembersInHierarchyDto> institutionalPages;

}
