package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO of a join request or invitation.
 */
@Data
@Builder
@AllArgsConstructor
@Schema(name = "OutputPendingMemberRequestDto", description = "Output DTO of a join request or invitation")
public class OutputPendingMemberRequestDto {

    @Schema(
            description = "ID of the user",
            example = "33333333-aaaa-1111-0000-000000000000"
    )
    private UUID userId;

    @Schema(description = "The institutional page")
    private OutputInstitutionalPageDto institutionalPage;

    @Schema(description = "Indicate if the user should be added as wp leader", example = "false")
    private Boolean wpLeader;

    @Schema(description = "The invitation message", example = "Please join as a member")
    private String message;

}