package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;

import java.util.Set;
import java.util.UUID;

public class InstitutionalPageHasChildrenException extends WP2BusinessException {

    public static final String EXCEPTION_MESSAGE =
            "InstitutionalPage with id: '%s' cannot be deleted it has child institutional pages: '%s'";

    public InstitutionalPageHasChildrenException(
            UUID institutionalPageId,
            Set<UUID> childPageInstitutionalPageIds
    ) {
        super(EXCEPTION_MESSAGE.formatted(institutionalPageId, childPageInstitutionalPageIds));
    }

}
