package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;

import java.util.List;

@Mapper(config = MapperConfiguration.class)
public interface ParagraphMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "institutionalPage", ignore = true)
    @Mapping(target = "institutionalPageId", ignore = true)
    ParagraphEntity toEntity(InputParagraphDto model);

    OutputParagraphDto toDto(ParagraphEntity entity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "institutionalPage", ignore = true)
    @Mapping(target = "institutionalPageId", ignore = true)
    void updateEntity(@MappingTarget ParagraphEntity entity, InputParagraphDto inputParagraphDto);

    @Named("cloneParagraphList")
    List<ParagraphEntity> cloneParagraphList(List<ParagraphEntity> src);

    List<ParagraphEntity> inputParagraphListToParagraphEntityList(List<InputParagraphDto> src);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "institutionalPage", ignore = true)
    @Mapping(target = "version", ignore = true)
    ParagraphEntity cloneParagraph(ParagraphEntity paragraph);

}
