/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.ModerationApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPModerationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPendingInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputModerationDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModerationController
implements ModerationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModerationController.class);
    private final InstitutionalPageService institutionalPageService;

    public Page<OutputInstitutionalPageDto> findAllLatestVersionPendingInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/pending");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.findAllLatestVersionPendingInstitutionalPages(userId, associationsToLoad, (Pageable)pageable);
    }

    public Page<OutputInstitutionalPageDto> searchLatestVersionPendingInstitutionalPages(InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/pending/search, inputSearchPendingInstitutionalPageDto: {}", (Object)inputSearchPendingInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.searchLatestVersionPendingInstitutionalPages(userId, associationsToLoad, (Pageable)pageable, inputSearchPendingInstitutionalPageDto);
    }

    public OutputInstitutionalPageDto findLatestVersionPendingInstitutionalPageById(UUID institutionalPageId) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/pending/{}", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.findLatestVersionPendingInstitutionalPageById(userId, institutionalPageId);
    }

    public OutputModerationDto acceptOrRejectPendingInstitutionalPage(UUID institutionalPageId, InputPatchIPModerationRequestDto inputPatchIPModerationRequestDto) {
        log.debug("PATCH /api/v1/dm/institutional-page/institutional-pages/pending/{}, inputPatchIPModerationRequestDto: {}", (Object)institutionalPageId, (Object)inputPatchIPModerationRequestDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.acceptOrRejectPendingInstitutionalPage(userId, institutionalPageId, inputPatchIPModerationRequestDto);
    }

    @Generated
    public ModerationController(InstitutionalPageService institutionalPageService) {
        this.institutionalPageService = institutionalPageService;
    }
}

